this.name		= "swi_autoJumper";
this.author		= "Switeck";
this.copyright	= "(C) 2023 Switeck";
this.licence		= "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description= "Automated jump system";
this.version		= "0.56.42 - for Oolite 1.80 and later";

"use strict";
swiJumpRoute = [-9];
swiJumpCount = -9;

// CURRENTLY UNUSED:
// So long as curX and curY is defined before calling this, it can find the nearest 2 systems to ANY X,Y coordinate!
this.$findNearestSystem = function()
{
// Stores player ship current location's X and Y
	var curX = Math.floor(player.ship.galaxyCoordinates.x);
	var curY = Math.floor(player.ship.galaxyCoordinates.y);
//	if(swiPrevJump<0 || swiPrevJump>255) swiPrevJump=system.ID;

	var shortDis = 9999;
	for (var i=0; i< 256; i++) {
		if(i != system.ID || system.isInterstellarSpace) {
			var swiDestX = Math.floor(System.infoForSystem(galaxyNumber,i).internalCoordinates.x);
			var swiDestY = Math.floor(System.infoForSystem(galaxyNumber,i).internalCoordinates.y);
			var xDif = Math.floor(Math.abs(curX - swiDestX));
			var yDif = Math.floor(Math.abs(curY - swiDestY)*0.5);
			var iDis = 0.4*Math.floor(Math.sqrt(xDif*xDif + yDif*yDif));
			var iDis = Number(iDis.toFixed(1));

			var iDis2 = Math.floor(10*System.infoForSystem(galaxyNumber, system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,i)))/10;
//			log(this.name,parseInt(i),".LY distance = ",iDis," vs ",iDis2," Cur x,y:",curX,curY,"Dest x,y:",swiDestX,swiDestY," xDif,yDif:",xDif,yDif);

//			if(iDis <= 7) if(iDis <= shortDis) {
			if(iDis <= 7) {
// If that route exists, THEN check the time to do it. If time needed is less than previous "best route", use this route instead.

// MUCH better now done to determine if the path to swiPrevJump is reachable normally...and if so, then compare route distances rather than straight-line distances.
// Instead of checking for only the 2 closest systems, do chain distance tests from any reachable system to destination.
			if(System.infoForSystem(galaxyNumber,i).routeToSystem(System.infoForSystem(galaxyNumber, swiPrevJump),"OPTIMIZED_BY_TIME") ) {
				var iDis = iDis*iDis + System.infoForSystem(galaxyNumber,i).routeToSystem(System.infoForSystem(galaxyNumber,swiPrevJump), "OPTIMIZED_BY_TIME").time; // needs to be the amount of TIME, not the jump-route!
			} else {
				var iDis = iDis + System.infoForSystem(galaxyNumber, i).distanceToSystem(System.infoForSystem(galaxyNumber, swiPrevJump));
				if(iDis <7) iDis = iDis*iDis	//	iDis = 0;
				else iDis = 600 + iDis*iDis;
			}
				if(iDis <= shortDis) {
					shortDis = iDis;
					swiNextJump = i;
				}
			}
		}
	}

//	player.commsMessage("shortDis 1&2 and jumpDis: "+shortDis+", "+iDis2+" LY for systems "+swiNextJump+", "+lastJump+", "+player.ship.targetSystem,6);
	log(this.name,"shortest time: ",shortDis," hours and jumpDis distance: ",iDis2," LY from system ",system.ID," to systems ",swiNextJump,swiPrevJump,player.ship.targetSystem);
//	player.commsMessage("Nearest systems: "+system.info.systemsInRange(7.0),6);

// Compares both closest systems + remaining route TIME-WISE to just going straight to swiPrevJump if total jumpDis < 7 LY.
	if(shortDis * shortDis >= iDis2*iDis2 && iDis2 <7.0) {
		swiNextJump = swiPrevJump;
		player.commsMessage("Jumping straight to destination!",6);
	}
}

// WyldRide jump path creator!
this.WyldRide = function(choice)
{
	switch(choice)
	{
		case  1:	{ swiJumpRoute = swiJumpRoute.concat([2883,2886,3372,4369,4183,6186,6883,7886,7372,8369,8183,9186,9883,10886,10372,12369,12183,13186,13883,15886]); break;	}
		case  2:	{ swiJumpRoute = swiJumpRoute.concat([2372,2369,3883,4886,5183,6186,7372,8369,9883,10886,11183,12186,13372,14369,15883,35886]); break;	}
		case  3:	{ swiJumpRoute = swiJumpRoute.concat([2183,2186,3372,4886,5883,7369,9183,10186,12372,13886,15883,17369]); break;	}
		case  4:	{ swiJumpRoute = swiJumpRoute.concat([2883,2886,3183,4186,5372,7369,9883,10886,12183,14186,18372,20369]); break;	}
		case  5:	{ swiJumpRoute = swiJumpRoute.concat([2372,3369,4883,3886,4183,6186,7372,9369,13883,15886,17183,18186]); break;	}
		case  6:	{ swiJumpRoute = swiJumpRoute.concat([8183,10186,8372,10369,8883,10886,8183,10186,18372,20369]); break;	}
		case  7:	{ swiJumpRoute = swiJumpRoute.concat([8883,10886,8183,10186,8372,10369,8883,10886,19183,20186]); break;	}
		case  8:	{ swiJumpRoute = swiJumpRoute.concat([8372,10369,13883,15886,8183,10186,12372,14369,19883,18886]); break;	}
		case  9:	{ swiJumpRoute = swiJumpRoute.concat([8183,10186,13372,15369,8883,10886,8183,10186,18372,20369]); break;	}
		case 10:	{ swiJumpRoute = swiJumpRoute.concat([8883,10886,13183,15186,8372,8369,13883,15886,19183,18186]); break;	}
		case 11:	{ swiJumpRoute = swiJumpRoute.concat([8372,10369,13883,15886,13183,15186,16372,17369]); break;	}
		case 12:	{ swiJumpRoute = swiJumpRoute.concat([8183,10186,13372,15369,13883,15886,19183,20186]); break;	}
		case 13:	{ swiJumpRoute = swiJumpRoute.concat([8372,10369,7883,8886,13183,15186,19372,18369]); break;	}
		case 14:	{ swiJumpRoute = swiJumpRoute.concat([8183,10186,8372,10369,8883,10886,16183,18186]); break;	}
		case 15:	{ swiJumpRoute = swiJumpRoute.concat([8883,8886,10183,12186,12372,15369,17883,18886]); break;	}
		case 16:	{ swiJumpRoute = swiJumpRoute.concat([6183,6186,7183,9186,13183,15186,17183,18186]); break;	}

		case 17:	{ swiJumpRoute = swiJumpRoute.concat([66666,75861,80885,85462,90434,79793,23372]); break;	}
		case 18:	{ swiJumpRoute = swiJumpRoute.concat([80821,20462,30886,35462,35369,35793,35886,50462,23883]); break;	}
		case 19:	{ swiJumpRoute = swiJumpRoute.concat([50093,50462,25793,10883,20821,25372]); break;	}
		case 20:	{ swiJumpRoute = swiJumpRoute.concat([50434,50793,50462,25093,20883]); break;	}
		case 21:	{ swiJumpRoute = swiJumpRoute.concat([85821,80793,23372]); break;	}
		case 22:	{ swiJumpRoute = swiJumpRoute.concat([50121,81462,20883]); break;	}
		case 23:	{ swiJumpRoute = swiJumpRoute.concat([28821,78462,23883]); break;	}

		case 24:	{ swiJumpRoute = swiJumpRoute.concat([50515,50884,50186]); break;	}
		case 25:	{ swiJumpRoute = swiJumpRoute.concat([50740,50184,50369]); break;	}
		case 26:	{ swiJumpRoute = swiJumpRoute.concat([50515,50884,50886]); break;	}
		case 27:	{ swiJumpRoute = swiJumpRoute.concat([50040,50371,50886]); break;	}

		case 28:	{ swiJumpRoute = swiJumpRoute.concat([29821,35883,33821]); break;	}
		case 29:	{ swiJumpRoute = swiJumpRoute.concat([25434,26883,29434]); break;	}
		case 30:	{ swiJumpRoute = swiJumpRoute.concat([25821,25883,28434]); break;	}
		case 31:	{ swiJumpRoute = swiJumpRoute.concat([25434,28372,30821]); break;	}
		case 32:	{ swiJumpRoute = swiJumpRoute.concat([25821,4434]); break;	}
		case 33:	{ swiJumpRoute = swiJumpRoute.concat([28434]); break;	}
		case 34:	{ swiJumpRoute = swiJumpRoute.concat([30434,35883,33821]); break;	}

		case 35:	{ swiJumpRoute = swiJumpRoute.concat([3886,2372,3369]); break;	}
		case 36:	{ swiJumpRoute = swiJumpRoute.concat([3369,2883,3886]); break;	}
		case 37:	{ swiJumpRoute = swiJumpRoute.concat([3886,2372,3886]); break;	}

		case 38:	{ swiJumpRoute = swiJumpRoute.concat([40884,52932,52884,23323,20829,20371,20829,30884,30829,30371,30829,30884,30829,99349,50256,306,406,506,606,706,806,906]); break;	}
		case 39:	{ swiJumpRoute = swiJumpRoute.concat([52184,23323,20829,20371,20829,30884,30829,30371,30829,30884,30829,99349,50256,606,906]); break;	}
		case 40:	{ swiJumpRoute = swiJumpRoute.concat([52371,23323,20829,20371,99422,50256,606]); break;	}
		case 41:	{ swiJumpRoute = swiJumpRoute.concat([40184,69133,99349,50256,206,306,406,506,606,706,806,906]); break;	}
		case 42:	{ swiJumpRoute = swiJumpRoute.concat([40884,79422,99349,50256,206,306,406,506,606,706,806,906]); break;	}
		case 43:	{ swiJumpRoute = swiJumpRoute.concat([40371,89833,99349,50256,206,606,906]); break;	}
		case 44:	{ swiJumpRoute = swiJumpRoute.concat([40184,133,206,306,406]); break;	}
		case 45:	{ swiJumpRoute = swiJumpRoute.concat([40371,422,906,606,306]); break;	}
		case 46:	{ swiJumpRoute = swiJumpRoute.concat([40884,833,349,906,422]); break;	}
		case 47:	{ swiJumpRoute = swiJumpRoute.concat([40884,89422,666]); break;	}
		case 48:	{ swiJumpRoute = swiJumpRoute.concat([40184,133,906]); break;	}
		case 49:	{ swiJumpRoute = swiJumpRoute.concat([40371,133,349]); break;	}
		case 50:	{ swiJumpRoute = swiJumpRoute.concat([40884,833,906]); break;	}
		case 51:	{ swiJumpRoute = swiJumpRoute.concat([40371,422,206]); break;	}
		case 52:	{ swiJumpRoute = swiJumpRoute.concat([40184,133,306]); break;	}
		case 53:	{ swiJumpRoute = swiJumpRoute.concat([40371,833,606]); break;	}
		case 54:	{ swiJumpRoute = swiJumpRoute.concat([40884,422,966]); break;	}
		case 55:	{ swiJumpRoute = swiJumpRoute.concat([40184,133]); break;	}
		case 56:	{ swiJumpRoute = swiJumpRoute.concat([50184,5232,133]); break;	}
		case 57:	{ swiJumpRoute = swiJumpRoute.concat([40884,89422,666]); break;	}
		case 58:	{ swiJumpRoute = swiJumpRoute.concat([35184,133]); break;	}

		case 59:	{ swiJumpRoute = swiJumpRoute.concat([25121,25883]); break;	}
		case 60:	{ swiJumpRoute = swiJumpRoute.concat([25434,25183]); break;	}
		case 61:	{ swiJumpRoute = swiJumpRoute.concat([25821,25372]); break;	}

		case 62:	{ swiJumpRoute = swiJumpRoute.concat([22183,24886]); break;	}
		case 63:	{ swiJumpRoute = swiJumpRoute.concat([22883,24369]); break;	}
		case 64:	{ swiJumpRoute = swiJumpRoute.concat([22372,24186]); break;	}

		case 65:	{ swiJumpRoute = swiJumpRoute.concat([50740,50186]); break;	}
		case 66:	{ swiJumpRoute = swiJumpRoute.concat([50515,50369]); break;	}
		case 67:	{ swiJumpRoute = swiJumpRoute.concat([50040,50886]); break;	}

		case 68:	{ swiJumpRoute = swiJumpRoute.concat([50040,50323]); break;	}
		case 69:	{ swiJumpRoute = swiJumpRoute.concat([50515,50232]); break;	}
		case 70:	{ swiJumpRoute = swiJumpRoute.concat([50740,50932]); break;	}

		case 71:	{ swiJumpRoute = swiJumpRoute.concat([50184,50932]); break;	}
		case 72:	{ swiJumpRoute = swiJumpRoute.concat([50884,50323]); break;	}
		case 73:	{ swiJumpRoute = swiJumpRoute.concat([50371,50232]); break;	}

		case 74:	{ swiJumpRoute = swiJumpRoute.concat([50186]); break;	}
		case 75:	{ swiJumpRoute = swiJumpRoute.concat([50886]); break;	}
		case 76:	{ swiJumpRoute = swiJumpRoute.concat([50369]); break;	}

		case 77:	{ swiJumpRoute = swiJumpRoute.concat([75093,25818,23434,25183]); break;	}
		case 78:	{ swiJumpRoute = swiJumpRoute.concat([75793,25437,23121,25372]); break;	}
		case 79:	{ swiJumpRoute = swiJumpRoute.concat([75462,25118,23821,25883]); break;	}
		case 80:	{ swiJumpRoute = swiJumpRoute.concat([69093,20818]); break;	}
		case 81:	{ swiJumpRoute = swiJumpRoute.concat([69093,20437,29821,25183]); break;	}
		case 82:	{ swiJumpRoute = swiJumpRoute.concat([69093,20118,29434,32883]); break;	}
		case 83:	{ swiJumpRoute = swiJumpRoute.concat([69093,20818,29121,32372,30821,33883,30434,26183,29434]); break;	}

		case 84:	{ swiJumpRoute = swiJumpRoute.concat([50040,50186,50040,50232,45040,25184,35232]); break;	}
		case 85:	{ swiJumpRoute = swiJumpRoute.concat([50040,50040,50186,50040,25184,35232]); break;	}
		case 86:	{ swiJumpRoute = swiJumpRoute.concat([50040,50040,25184,25186,25184,40232]); break;	}
		case 87:	{ swiJumpRoute = swiJumpRoute.concat([75040,25184,25186,25184,40232]); break;	}
		case 88:	{ swiJumpRoute = swiJumpRoute.concat([75040,25184,25186,25184,38232]); break;	}
		case 89:	{ swiJumpRoute = swiJumpRoute.concat([75040,34184,31186,40184,50232,62184,133]); break;	}
		case 90:	{ swiJumpRoute = swiJumpRoute.concat([75040,30184,31186,40184,50232,63184,133]); break;	}
		case 91:	{ swiJumpRoute = swiJumpRoute.concat([76040,34184,26186,34184,50232,62184,133]); break;	}
		case 92:	{ swiJumpRoute = swiJumpRoute.concat([75040,35184,26186,34184,50232,62184,133]); break;	}
		case 93:	{ swiJumpRoute = swiJumpRoute.concat([75040,35184,25186,33184,50232,62184,133]); break;	}

		case 94:	{ swiJumpRoute = swiJumpRoute.concat([50883,50462,25818,23434,25183]); break;	}
		case 95:	{ swiJumpRoute = swiJumpRoute.concat([50183,50793,25437,23434,25372]); break;	}
		case 96:	{ swiJumpRoute = swiJumpRoute.concat([50883,50093,25818,23821,25883]); break;	}
		case 97:	{ swiJumpRoute = swiJumpRoute.concat([25372,25818,23121,25183]); break;	}
		case 98:	{ swiJumpRoute = swiJumpRoute.concat([25883,25437,23821,25372]); break;	}
		case 99:	{ swiJumpRoute = swiJumpRoute.concat([25372,25818,23434,25883]); break;	}
	}
}

this.activated = function()
{
	if(player.ship.equipmentStatus("EQ_WORMHOLE_SCANNER") == "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_ADVANCED_NAVIGATIONAL_ARRAY") == "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_SWI_AUTOJUMPER") == "EQUIPMENT_OK") {	// Checks to see if the equipment is even working...if not, STOP!
	swiJumpRoute = [-7];	// Initializes important variables
	swiJumpCount = -8;
	swiPrevJump = -9;
	var s = system.ID;
	var t = player.ship.targetSystem;
	if(missionVariables.swi_Jumper > 4 || missionVariables.swi_Jumper == null) missionVariables.swi_Jumper = 0;

// Checks to see if in alternate Oolite universe!
	var testCoords=[[4.8,40.6,0],[9.6,30.4,0],[31.2,42.4,0],[62.4,34.2,0],[51.2,28.8,0],[86.4,27.6,0],[70.8,4.6,0],[90.8,39.8,0]];
	if (System.infoForSystem(galaxyNumber, 255).coordinates.distanceTo(testCoords[galaxyNumber]) > 0.1 || galaxyNumber <0 || galaxyNumber >7) {	// Also checks if OUTSIDE the usual Galaxy Charts 1-8 (internally called 0-7)
		player.commsMessage("Outside known space! No matching Star Charts found! Only short-ranged (0-7 LY) jumps possible!",20);	// DIRE warnings about being off-the-charts.
		log(this.name,"Outside known space! No matching Star Charts found! Only short-ranged (0-7 LY) jumps possible!");
		var swiDis = 9;	// Fake distance
	} else if(missionVariables.swi_Jumper < 3) {
	if(galaxyNumber == 0) {
		if(s ==  74 && t ==247) swiJumpRoute = [74,50194,247];	// 69.76 hours
		if(s ==  74 && t ==  74) swiJumpRoute = [74,50194,247];	// 69.76 hours
		if(s ==194 && t ==194) swiJumpRoute = [194,50074,247];	// 69.76 hours
		if(s ==194 && t ==247) swiJumpRoute = [194,50074,247];	// 69.76 hours

		if(s ==  10 && t ==255) swiJumpRoute = [10,50177,255];	// 68.06 hours - Bottom Left HARD turn, includes 0.1% misjump to 255
		if(s ==  10 && t ==  10) swiJumpRoute = [10,50177,255];	// 68.06 hours - Bottom Left HARD turn, includes 0.1% misjump to 255

		if(s ==  76 && t ==  76) swiJumpRoute = [76,50166,75141,75226,211];	// 148.57 hours
		if(s ==  76 && t ==211) swiJumpRoute = [76,50166,75141,75226,211];	// 148.57 hours

		if(s ==238 && t ==238) swiJumpRoute = [238,25223,50213,50238,28015,58213,30059,99160,99208,69];
		if(s ==238 && t ==160) swiJumpRoute = [238,25223,50213,50238,28015,58213,30059,99160,99208,69];
	}
	if(galaxyNumber == 1) {
		if(s ==  10 && t ==  10) swiJumpRoute = [10,50172,50012,50012,50012,50010,192];
		if(s ==  10 && t ==192) swiJumpRoute = [10,50172,50012,50012,50012,50010,192];
		if(s ==  12 && t ==  12) swiJumpRoute = [12,50172,50012,50012,50012,50010,192];
		if(s ==  12 && t ==192) swiJumpRoute = [12,50172,50012,50012,50012,50010,192];
		if(s ==172 && t ==172) swiJumpRoute = [172,50010,50012,50012,50012,50010,192];
		if(s ==172 && t ==192) swiJumpRoute = [172,50010,50012,50012,50012,50010,192];

		if(s ==175 && t ==  27) swiJumpRoute = [175,50220,50192,50175,50175,27];	// 119.6 hours
		if(s ==175 && t ==175) swiJumpRoute = [175,50220,50192,50175,50175,27];	// 119.6 hours
		if(s ==192 && t ==  27) swiJumpRoute = [192,50220,50175,50192,50175,50175,27];	// 140.69 hours
		if(s ==192 && t ==192) swiJumpRoute = [192,50220,50175,50192,50175,50175,27];	// 140.69 hours
		if(s ==220 && t ==  27) swiJumpRoute = [220,50175,50192,50175,50175,27];	// 119.6 hours
		if(s ==220 && t ==220) swiJumpRoute = [220,50175,50192,50175,50175,27];	// 119.6 hours
		if(s ==252 && t ==  72) swiJumpRoute = [252,50019,72];	// 64.49 hours
		if(s ==252 && t ==252) swiJumpRoute = [252,50019,72];	// 64.49 hours	- middle/center of map HARD turn West then South.
		if(s ==  72 && t ==  72) swiJumpRoute = [72,50019,252];
		if(s ==  72 && t ==252) swiJumpRoute = [72,50019,252];
	}
	if(galaxyNumber == 2) {
// Attacking into the VOID!
		if(s ==144 && t ==144) swiJumpRoute = [144,87151,50192];	// location of a Thargoid Invasion fleet? VERY Bottom center of map
		if(s ==224 && t ==    0) swiJumpRoute = [224,50170,50000,50170,50000,50170];	// [224,87170,50000];	can't be done as-is, because it uses wormhole stacking.
		if(s ==224 && t ==224) swiJumpRoute = [224,75170,75170,87231,50000];	// left side of map, center from top to bottom

//		if(s ==102 && t ==225) swiJumpRoute = [102,60167,225];	// quicker to let automatic shortcut misjump finder work!
		if(s ==167 && t ==102) swiJumpRoute = [167,50225,50102];	// void location near far right side, very close to 145 (above) and 226 (left)
		if(s ==167 && t ==167) swiJumpRoute = [167,50225,50102];

		if(s ==  50 && t ==  23) swiJumpRoute = [50,50065,23];	// Top center triangle turn
		if(s ==  23 && t ==  50) swiJumpRoute = [23,50065,50];	// Top center triangle turn

		if(s ==158 && t ==243) swiJumpRoute = [158,50051,243];	// Middle-of-map triangle turn
		if(s ==243 && t ==158) swiJumpRoute = [243,50051,158];	// Middle-of-map triangle turn
		if(s ==124 && t ==158) swiJumpRoute = [124,50051,158];	// Middle-of-map triangle turn
		if(s ==158 && t ==124) swiJumpRoute = [158,50051,124];	// Middle-of-map triangle turn

		if(s ==171 && t ==207) swiJumpRoute = [171,50144,207];	// bottom middle HARD turn
		if(s ==207 && t ==171) swiJumpRoute = [207,50144,171];	// bottom middle HARD turn

		if(s ==  18 && t ==138) swiJumpRoute = [18,50000,138];	// 46.45 hours vs 62.2 hours long way round	TOP RIGHT turn-off to dead-end spur
		if(s ==  18 && t ==  18) swiJumpRoute = [18,50000,138];	// 46.45 hours vs 62.2 hours long way round

// CRAZY-Attempting to reach the unreachable systems at top!
		if((t ==133 || t ==206 || (s ==  54 && t ==  54) || (s == 93 && t ==  93) || (s ==118 && t ==118) || (s ==121 && t ==121) || (s ==183 && t ==183)) && s !=133 && s !=206 && !system.isInterstellarSpace) {
// WyldRide jump path creator!
		var swiDis = Math.log(player.score+1);
			swiJumpRoute = [0];
			swiJumpRoute[0] = (513 - 454)*2;
		if(s==54 || s==118 || s==121 || s==129 || s==161 || s==165 || s==185 || s==186 || s==232) {
			this.WyldRide(Math.min(23,Math.floor(17+Math.random()*(2+swiDis*0.5))));
		} else if(s==0 || s==31 || s==93 || s==169 || s==190 || s==216 || s==229) {
			swiJumpRoute[0] = swiJumpRoute[0] + 675;
			var i = Math.floor(94+Math.min(12,(Math.random()+Math.random())*swiDis));
			if( i > 99) {
				i = i - 23;
				this.WyldRide(i);
				if(i < 80) swiJumpRoute[1] = 25372
				else swiJumpRoute[1] = 100976 - swiJumpRoute[1];
			} else this.WyldRide(i);
		} else {
			swiJumpRoute[0] = swiJumpRoute[0] + 254;
			this.WyldRide(Math.floor(77+Math.min(6,(Math.random()*swiDis))));
		}
		var i2=3;
		if( i < 83 || i > 93) {
		var i2 = Math.max(3,Math.ceil((Math.random()+Math.random())*(10-swiDis)));
		for(var i3=0; i3< i2; i3++) this.WyldRide(Math.floor(59+Math.random()*3));
		this.WyldRide(Math.floor(28+Math.min(6,(i2-3+Math.random())*2)));
		}
		this.WyldRide(Math.floor(35+Math.random()*3));
		this.WyldRide(Math.min(16,Math.floor(2*(Math.random()+Math.random())*(i2+swiDis))));
		this.WyldRide(Math.floor(62+Math.random()*3));
		if(t ==133 || t ==206) {
		var i2 = Math.max(0,Math.floor((Math.random()+Math.random())*(5-(swiDis*0.5))));
		if( i2 < 1) {
			this.WyldRide(Math.floor(74+Math.random()*3));
			this.WyldRide(Math.floor(Math.min(93,84+Math.random()*swiDis)));
		} else {
			for(var i3=0; i3< i2; i3++) this.WyldRide(Math.floor(65+Math.random()*3));
			var i2 = Math.ceil((Math.random()+Math.random())*(5-(swiDis*0.5)));
			if( i2 > 1) {
				for(var i3=0; i3< i2; i3++) this.WyldRide(Math.floor(68+Math.random()*3));
				this.WyldRide(Math.floor(24+Math.random()*4));
			}
		}
		if( i < 89) {
			var i2 = Math.ceil(Math.max(2,(Math.random()+Math.random())*(5-(swiDis*0.5))));
			if( i > 83) var i2 = 1;
			for(var i3=0; i3< i2; i3++) this.WyldRide(Math.floor(71+Math.random()*3));
			this.WyldRide(Math.min(58,Math.floor(Math.random()*Math.random()*8+swiDis+38)));
		}
		}
			swiDis = 9;
		}
	}
	if(galaxyNumber == 3) {
		if(s ==   27 && t == 27) swiJumpRoute = [27,50239,50]; // 27/50 sharp angle jump pair to dead-end system 182 top right
		if(s ==   27 && t == 50) swiJumpRoute = [27,50239,50]; // 27/50
		if(s ==   50 && t == 27) swiJumpRoute = [50,50239,27]; // 27/50
		if(s ==   50 && t == 50) swiJumpRoute = [50,50239,27]; // 27/50
		if(s ==   27 && t ==182) swiJumpRoute = [27,50239,50,182]; // 27/50 sharp angle jump pair to dead-end system 182 top right
		if(s ==   65 && t ==182) swiJumpRoute = [65,50239,50050,50,182]; // 27/50 sharp angle jump pair to dead-end system 182 top right

		if(s ==  21 && t ==  21) swiJumpRoute = [21,50111,176]; // 21/176 "trade route" middle bottom
		if(s ==  21 && t ==176) swiJumpRoute = [21,50111,176]; // 21/176
		if(s ==176 && t ==  21) swiJumpRoute = [176,50111,21]; // 21/176
		if(s ==176 && t ==176) swiJumpRoute = [176,50111,21]; // 21/176

		if(s ==156 && t ==156) swiJumpRoute = [156,50178,172]; // 156/172 "trade route" middle top
		if(s ==156 && t ==172) swiJumpRoute = [156,50178,172]; // 156/172
		if(s ==172 && t ==156) swiJumpRoute = [172,50178,156]; // 156/172
		if(s ==172 && t ==172) swiJumpRoute = [172,50178,156]; // 156/172

		if(s ==141 && t ==141) swiJumpRoute = [141,50006,206]; // sharp turn bottom right on map
		if(s ==141 && t ==206) swiJumpRoute = [141,50006,206]; // sharp turn bottom right on map
		if(s ==206 && t ==141) swiJumpRoute = [206,50006,141];
		if(s ==206 && t ==206) swiJumpRoute = [206,50006,141];
	}
	if(galaxyNumber == 4) {
		if(s ==109 && t ==  55) swiJumpRoute = [109,50100,50239,55];	// x hours
		if(s ==109 && t ==109) swiJumpRoute = [109,50100,50239,55];	// x hours

		if(s ==239 && t ==128) swiJumpRoute = [239,50109,50109,50100,128]; // 107.09 hours
		if(s ==239 && t ==239) swiJumpRoute = [239,50109,50109,50100,128]; // 107.09 hours

		if(s ==  41 && t ==  41) swiJumpRoute = [41,50222,186]; // 41/186 sharp angle jump pair.
		if(s ==  41 && t ==186) swiJumpRoute = [41,50222,186]; // 41/186
		if(s ==186 && t ==  41) swiJumpRoute = [186,50222,41]; // 41/186
		if(s ==186 && t ==186) swiJumpRoute = [186,50222,41]; // 41/186

		if(s ==148 && t ==148) swiJumpRoute = [148,50164,208]; // 148/208 sharp angle jump pair.
		if(s ==148 && t ==208) swiJumpRoute = [148,50164,208]; // 148/208
		if(s ==208 && t ==148) swiJumpRoute = [208,50164,148]; // 148/208
		if(s ==208 && t ==208) swiJumpRoute = [208,50164,148]; // 148/208

		if(s ==  81 && t ==  81) swiJumpRoute = [81,50213,50213,160]; // 81/160 sharp angle jump pair.
		if(s ==  81 && t ==160) swiJumpRoute = [81,50213,50213,160]; // 81/160
		if(s ==160 && t ==  81) swiJumpRoute = [160,50213,50213,50213,81]; // 81/160
		if(s ==160 && t ==160) swiJumpRoute = [160,50213,50213,50213,81]; // 81/160
	}
	if(galaxyNumber == 5) {
		if(s == 100 && t ==  89) swiJumpRoute = [100,50148,89];	// 61.24 hours
		if(s == 108 && t ==108) swiJumpRoute = [108,50143,244];	// 66.52 hours
		if(s == 108 && t ==244) swiJumpRoute = [108,50143,244];	// 66.52 hours
		if(s == 143 && t ==143) swiJumpRoute = [143,50143,244];	// 66.52 hours
		if(s == 143 && t ==244) swiJumpRoute = [143,50143,244];	// 66.52 hours

		if(s ==   36 && t ==  36) swiJumpRoute = [36,50221,50045,50045,50036,50045,50036,214]; // 158.09 hours
		if(s ==   36 && t ==214) swiJumpRoute = [36,50221,50045,50045,50036,50045,50036,214]; // 158.09 hours
		if(s ==   45 && t ==  45) swiJumpRoute = [45,50154,50036,50045,50045,50036,214]; // 153.41 hours
		if(s ==   45 && t ==214) swiJumpRoute = [45,50154,50036,50045,50045,50036,214]; // 153.41 hours
		if(s == 154 && t ==154) swiJumpRoute = [154,50045,50036,50045,50045,50036,214]; // 153.41 hours - ORIGINAL
		if(s == 154 && t ==214) swiJumpRoute = [154,50045,50036,50045,50045,50036,214]; // 153.41 hours - ORIGINAL
		if(s == 221 && t ==214) swiJumpRoute = [221,50045,50045,50036,50045,50045,50036,214]; // 167.57 hours
		if(s == 221 && t ==221) swiJumpRoute = [221,50045,50045,50036,50045,50045,50036,214]; // 167.57 hours

		if(s ==   89 && t ==  89) swiJumpRoute = [89,50148,100];	// 61.72 hours
		if(s ==   89 && t ==100) swiJumpRoute = [89,50148,100];	// 61.72 hours
		if(s == 100 && t ==  89) swiJumpRoute = [100,50148,89];	// 61.24 hours
		if(s == 100 && t ==100) swiJumpRoute = [100,50148,89];	// 61.24 hours
		if(s == 100 && t ==222) swiJumpRoute = [100,50199,222];	// 67.96 hours
		if(s == 108 && t ==108) swiJumpRoute = [108,50143,244];	// 66.52 hours
		if(s == 108 && t ==244) swiJumpRoute = [108,50143,244];	// 66.52 hours
		if(s == 143 && t ==143) swiJumpRoute = [143,50108,244];	// 66.52 hours?
		if(s == 143 && t ==244) swiJumpRoute = [143,50108,244];	// 66.52 hours?
		if(s ==   26 && t ==  26) swiJumpRoute = [26,50244,108];	// ? hours
		if(s ==   26 && t ==108) swiJumpRoute = [26,50244,108];	// ? hours
		if(s == 244 && t ==108) swiJumpRoute = [244,50026,108];	// ? hours
		if(s == 244 && t ==244) swiJumpRoute = [244,50026,108];	// ? hours

		if(s == 133 && t ==133) swiJumpRoute = [133,50040,50040,50133,50187,157];	// 136.61 hours
		if(s == 133 && t ==157) swiJumpRoute = [133,50040,50040,50133,50187,157];	// 136.61 hours

		if(s == 158 && t ==158) swiJumpRoute = [158,50085,213];	// x hours
		if(s == 158 && t ==213) swiJumpRoute = [158,50085,213];	// x hours
		if(s == 213 && t ==158) swiJumpRoute = [213,50085,158];	// x hours
		if(s == 213 && t ==179) swiJumpRoute = [213,50085,50158,50158,179];	// x hours
		if(s == 213 && t ==213) swiJumpRoute = [213,50085,50158,50158,50158,179];	// x hours
		if(s == 232 && t ==251) swiJumpRoute = [232,50007,251];	// x hours
		if(s == 251 && t ==232) swiJumpRoute = [251,50007,232];	// x hours
		if(s == 251 && t ==238) swiJumpRoute = [251,50137,238];	// 69.77 hours
		if(s == 137 && t ==137) swiJumpRoute = [137,50251,238];	// 69.76 hours
		if(s == 137 && t ==238) swiJumpRoute = [137,50251,238];	// 69.76 hours

// Attempting to reach the impossibly unreachable center systems!
		if(s ==149 && t ==202) swiJumpRoute = [149,40226,50255,40226,50255,40226,25234,25255,25234,25255,25234,5159,5255,5159,5255,8159,10255,12159,15255,18159,20255,22159,23255,25159,25255,25159,25255,40159,10066,25046,5046,5046,5046,5046,3046,3046,2046,2046,1046,1046,1046,1046,1046,1046,1046,202]; // x hours
		if(s ==149 && t ==149) swiJumpRoute = [149,40226,50255,40226,50255,40226,25234]; // 149.54 hours

		if(s ==149 && t ==149) swiJumpRoute = [149,40226,50255,40226,50255,40226,25234,25255,25234,25255,25234,5159,5255,5159,5255,8159,10255,12159,15255,18159,20255,22159,23255,25159,25255,25159,25255,40159,10066,25046,5046,5046,5046,5046,202]; // x hours
		if(s ==149 && t ==  90) swiJumpRoute = [149,40226,50255,40226,50255,40226,25234,25255,25234,25255,25234,5159,5255,5159,5255,8159,10255,12159,15255,18159,20255,22159,23255,25159,25255,25159,25255,35159,15066,25046,5046,5046,5046,5046,202]; // x hours
		if(s ==149 && t ==226) swiJumpRoute = [149,40226,50255,40226,50255,40226,25234,25255,25234,25255,25234,5159,5255,5159,5255,8159,10255,12159,15255,18159,20255,22159,23255,25159,25255,25159,25255,32159,17066,25046,5046,5046,5046,5046,202]; // x hours
		if(s ==149 && t ==202) swiJumpRoute = [149,40226,50255,40226,50255,40226,25234,25255,25234,25255,25234,5159,5255,5159,5255,8159,10255,12159,15255,18159,20255,22159,23255,25159,25255,25159,26255,30159,20066,25046,5046,5046,5046,5046,202]; // x hours
		if(s ==149 && t ==255) swiJumpRoute = [149,40226,50255,40226,50255,40226,25234,25255,25234,25255,25234,5159,5255,5159,5255,8159,10255,12159,15255,18159,20255,22159,23255,25159,25255,25159,26255,28159,22066,25046,5046,5046,5046,5046,202]; // x hours
		if(s ==149 && t ==241) swiJumpRoute = [149,40226,50255,40226,50255,40226,25234]; // 149.54 hours
		if(s ==   -1 && t ==255) swiJumpRoute = [-1,25255,25234];
		if(s ==   -1 && t ==  30) swiJumpRoute = [-1,5255,5159];
		if(s ==   -1 && t ==  31) swiJumpRoute = [-1,25255,25159];
		if(s ==   -1 && t ==240) swiJumpRoute = [-1,15255,15159];
		if(s ==   -1 && t ==126) swiJumpRoute = [-1,5255];
		if(s ==   -1 && t ==226) swiJumpRoute = [-1,1226,1234];
		if(s ==   -1 && t ==234) swiJumpRoute = [-1,1234,1159,1066,1046,202];
		if(s ==   -1 && t ==159) swiJumpRoute = [-1,1159,1066,1046,202];
		if(s ==   -1 && t ==  66) swiJumpRoute = [-1,1066,1046,202];
		if(s ==   -1 && t ==  46) swiJumpRoute = [-1,1046,202];
	}
	if(galaxyNumber == 6) {
		if(s ==  31 && t ==189) swiJumpRoute = [31,50080,189];	// 64.48 hours	(58.6 hours going opposite direction) 189 almost by itself near center and a little to the right on the map
		if(s ==189 && t ==  31) swiJumpRoute = [189,50080,31];	// 58.6 hours leaving 189, which is almost by itself near center and a little to the right on the map

// Devoted to crossing the Great Rift!
// From anywhere in Gal. Chart 7 (besides a handful of systems near the Great Rift) to anywhere else! ONLY WORKS IF START AND END ARE BOTH NOT IN INTERSTELLAR SPACE!
		if(s !=26 && s !=178 && s !=188 && s !=243 && s >-1 && t >-1 && System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME") == null) {
// If direct path from start to system 17, probably on bottom left side of map...with only 1 known way "out" across the Great Rift to "normal" right side of map.
			if(System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,17),"OPTIMIZED_BY_TIME") ) {	// Checks if system 17 is reachable from start. If there is a direct path to system 17, probably on bottom left side of map.
				swiJumpRoute = System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,17),"OPTIMIZED_BY_TIME").route;	// build a route starting from "s" to 17
				swiJumpRoute = swiJumpRoute.concat([50178]);	// Tack in Great Rift crossing array stub. Maybe even borrow case lines from this.WyldRide?
				swiJumpRoute = swiJumpRoute.concat(System.infoForSystem(galaxyNumber,192).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").route);	// build a route starting from 192 to "t"
// If no direct path from start to system 17, probably on "normal" right side of map...?
			} else if(System.infoForSystem(galaxyNumber,17).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME") ) {	// Checks if the destination is reachable from system 17. If destination has a direct path to system 17, probably starts on "normal" right side of map!
// NEED TO Compare distances to 89/194 vs 36/46/180/192/212 to find closest!

// 1st comparison checks 89/194 vs 36 and 46 ...counting on there being no instances of 180,192,or 212 being closer than 89/194 where 36/46 wasn't.
//				if((System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,89),"OPTIMIZED_BY_TIME") < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,36),"OPTIMIZED_BY_TIME") && System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,89),"OPTIMIZED_BY_TIME") < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,46),"OPTIMIZED_BY_TIME")) || (System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,194),"OPTIMIZED_BY_TIME") < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,36),"OPTIMIZED_BY_TIME") && System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,194),"OPTIMIZED_BY_TIME") < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,46),"OPTIMIZED_BY_TIME"))) {

// This more complex if statement also considers extra time incurred after crossing the Great Rift...but not the time crossing the Great Rift itself, since those are about the same for each route.
				if((System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,89),"OPTIMIZED_BY_TIME").time + System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").time < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,36),"OPTIMIZED_BY_TIME").time + System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").time && System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,89),"OPTIMIZED_BY_TIME").time + System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").time < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,46),"OPTIMIZED_BY_TIME").time + System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").time) || (System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,194),"OPTIMIZED_BY_TIME").time + System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").time < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,36),"OPTIMIZED_BY_TIME").time + System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").time && System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,194),"OPTIMIZED_BY_TIME").time + System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").time < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,46),"OPTIMIZED_BY_TIME").time + System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").time)) {
// NONE of the Great Rift paths consider extra time after crossing the Great Rift because they're all using the same paths.
					// Inner check to see if 89 or 194 is closer.
					if(System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,89),"OPTIMIZED_BY_TIME").time < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,194),"OPTIMIZED_BY_TIME").time ) {
						swiJumpRoute = System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,89),"OPTIMIZED_BY_TIME").route;	// build a route starting from "s" to 89
						swiJumpRoute = swiJumpRoute.concat([50194]);	// Tack in Great Rift crossing array stub. Maybe even borrow case lines from this.WyldRide?
						swiJumpRoute = swiJumpRoute.concat(System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").route);	// build a route starting from 229 to "t"
					} else {
						swiJumpRoute = System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,194),"OPTIMIZED_BY_TIME").route;	// build a route starting from "s" to 194
						swiJumpRoute = swiJumpRoute.concat([50089]);	// Tack in Great Rift crossing array stub. Maybe even borrow case lines from this.WyldRide?
						swiJumpRoute = swiJumpRoute.concat(System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").route);	// build a route starting from 229 to "t"
					}
				} else {
					// Middle check to see if 46/180 is closer than 36/212.
					if((System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,46),"OPTIMIZED_BY_TIME").time < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,36),"OPTIMIZED_BY_TIME").time && System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,46),"OPTIMIZED_BY_TIME").time < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,212),"OPTIMIZED_BY_TIME").time) || (System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,180),"OPTIMIZED_BY_TIME").time < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,36),"OPTIMIZED_BY_TIME").time && System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,180),"OPTIMIZED_BY_TIME").time < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,212),"OPTIMIZED_BY_TIME").time)) {
						// Inner check to see if 46 is closer than 180.
						if(System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,46),"OPTIMIZED_BY_TIME") < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,180),"OPTIMIZED_BY_TIME") ) {
							swiJumpRoute = System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,46),"OPTIMIZED_BY_TIME").route;	// build a route starting from "s" to 46
							swiJumpRoute = swiJumpRoute.concat([50036,50212,50180,50192]);	// Tack in Great Rift crossing array stub. Maybe even borrow case lines from this.WyldRide?
							swiJumpRoute = swiJumpRoute.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").route);	// build a route starting from 178 to "t"
						} else {
							swiJumpRoute = System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,180),"OPTIMIZED_BY_TIME").route;	// build a route starting from "s" to 180
							swiJumpRoute = swiJumpRoute.concat([50036,50212,50180,50192]);	// Tack in Great Rift crossing array stub. Maybe even borrow case lines from this.WyldRide?
							swiJumpRoute = swiJumpRoute.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").route);	// build a route starting from 178 to "t"
						}
					} else {
						// Inner check to see if 212 is closer than 36. (192 is neglected as only 77 and 213 is likely closer than 212!)
//						player.consoleMessage("comparing 212 route vs 36: "+System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,212),"OPTIMIZED_BY_TIME").time+" , "+System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,36),"OPTIMIZED_BY_TIME").time,6);
						if(System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,212),"OPTIMIZED_BY_TIME").time < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,36),"OPTIMIZED_BY_TIME").time ) {
							// Inner check to see if 192 is closer than 212!
							if(System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,192),"OPTIMIZED_BY_TIME").time < System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,212),"OPTIMIZED_BY_TIME").time ) {
								swiJumpRoute = System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,192),"OPTIMIZED_BY_TIME").route;	// build a route starting from "s" to 192
								swiJumpRoute = swiJumpRoute.concat([50212,50036,50180,50192]);	// Tack in Great Rift crossing array stub. Maybe even borrow case lines from this.WyldRide?
								swiJumpRoute = swiJumpRoute.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").route);	// build a route starting from 178 to "t"
							} else {
								swiJumpRoute = System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,212),"OPTIMIZED_BY_TIME").route;	// build a route starting from "s" to 212
								swiJumpRoute = swiJumpRoute.concat([50036,50212,50180,50192]);	// Tack in Great Rift crossing array stub. Maybe even borrow case lines from this.WyldRide?
								swiJumpRoute = swiJumpRoute.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").route);	// build a route starting from 178 to "t"
							}
						} else {
							swiJumpRoute = System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,36),"OPTIMIZED_BY_TIME").route;	// build a route starting from "s" to 36
							swiJumpRoute = swiJumpRoute.concat([50212,50212,50180,50192]);	// Tack in Great Rift crossing array stub. Maybe even borrow case lines from this.WyldRide?
							swiJumpRoute = swiJumpRoute.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME").route);	// build a route starting from 178 to "t"
						}
					}
				}
			}
		} else {
		if(s ==178 && t ==178) swiJumpRoute = [50017,192];
		if(s ==178 && t ==192) swiJumpRoute = [50017,192];
		if(s ==188 && t ==188) swiJumpRoute = [188,50243,43053,25077,22243,36011,50077,50011,40077,173]; // 246.38 hours  Crossing into the Great Rift from bottom right
		if(s ==188 && t ==173) swiJumpRoute = [188,50243,43053,56077,18243,56011,56077,30011,173]; // 249.54 hours
		if(s ==243 && t ==243) swiJumpRoute = [243,50188,43053,25077,22243,36011,50077,50011,40077,173]; // 246.38 hours
		if(s ==243 && t ==173) swiJumpRoute = [243,50188,43053,56077,18243,56011,56077,30011,173]; // 249.54 hours
		if(s ==  26 && t ==  26) swiJumpRoute = [243,50188,43053,25077,22243,36011,50077,50011,40077,173]; // 246.38 hours
		if(s ==  26 && t ==173) swiJumpRoute = [243,50188,43053,56077,18243,56011,56077,30011,173]; // 249.54 hours
		}
	}
	if(galaxyNumber == 7) {
		if(s ==161 && t ==161) swiJumpRoute = [161,50255,50203,50203,50161,247];
		if(s ==161 && t ==247) swiJumpRoute = [161,50255,50203,50203,50161,247];
		if(s ==  29 && t ==153) swiJumpRoute = [29,50059,153]; // x hours
		if(s ==  61 && t ==  43) swiJumpRoute = [61,50097,43]; // 48.88 hours
		if(s ==  61 && t ==  61) swiJumpRoute = [61,50097,43]; // 48.88 hours
		if(s ==  76 && t ==  43) swiJumpRoute = [76,50097,43]; // x hours
		if(s ==  76 && t ==  76) swiJumpRoute = [76,50097,43]; // x hours
		if(s ==  97 && t ==  43) swiJumpRoute = [97,50061,43]; // 61.24 hours
		if(s ==  97 && t ==  97) swiJumpRoute = [97,50061,43]; // 61.24 hours

		if(s ==    9 && t ==   9) swiJumpRoute = [9,50121,50088,50118,50088,162]; // 181.01 hours
		if(s ==121 && t ==121) swiJumpRoute = [121,50009,50088,50118,50088,162]; // 181.01 hours
// From anywhere in Gal. Chart 8 (besides interstellar space) to dead-end system 162.Oresrati!
		if(s !=162 && t ==162 && !system.isInterstellarSpace) if(s !=118 && s !=121 && s !=137) swiJumpRoute = [9,50121,50088,50118,50088,162] // 181.01 hours
			else [121,50009,50088,50118,50088,162]; // 181.01 hours
	}

	if(swiJumpRoute[0] > 699 && swiJumpRoute[0] <1000) swiJumpRoute[0] = swiJumpRoute[0] - 700;
	if(swiJumpRoute[0] > 299 && swiJumpRoute[0] < 600) swiJumpRoute[0] = 555 - swiJumpRoute[0];
// Splices a jump Path route from current location to the starting point of a pre-programmed route ONTO the pre-programmed route!
	if(s > -1 && s != swiJumpRoute[0] && swiJumpRoute.length > 1 && swiJumpRoute[0] < 256) {
		swiJumpRoute = System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,swiJumpRoute[0]), "OPTIMIZED_BY_TIME").route.concat(swiJumpRoute.slice(1, swiJumpRoute.length)); // maybe -1 on swiJumpRoute.length-1 is needed here?
	} else if(system.isInterstellarSpace && parseInt(swiJumpRoute[0]) > -1) {	// ONLY does this if a fixed jump route is chosen, otherwise tries to do short <7 LY 1-jump later.
		swiPrevJump = parseInt(swiJumpRoute[0]);
		this.$findNearestSystem();
		swiJumpRoute = [System.infoForSystem(galaxyNumber,swiNextJump).routeToSystem(System.infoForSystem(galaxyNumber,swiJumpRoute[0]), "OPTIMIZED_BY_TIME").route].concat(swiJumpRoute);	// Adds calculated on-the-fly jump route to fixed jump route.
		swiJumpRoute = swiJumpRoute[0].concat(swiJumpRoute); // Puts the first jump twice but starts at the 2nd one in case misjumps are needed from/to there.
		swiPrevJump = -1;
		swiJumpCount = 1;
	}
	}	// END of mode that allows special/fixed jump routes.

	if(parseInt(swiJumpRoute[0]) < -1) {
		var swiDis = Number(System.infoForSystem(galaxyNumber,s).distanceToSystem(System.infoForSystem(galaxyNumber,t)).toFixed(1)); // Doesn't work outside Galaxy Charts 1-8!
		player.commsMessage("Current System: "+s+" Destination System: "+t+" Total Distance: "+swiDis+" LYs.",6);
		log(this.name,"Current System: "+s+" Destination System: "+t+" Total Distance: "+swiDis+" LYs.");
	if(s == t) swiJumpRoute = [s,299]	// 299 = Jump to a random nearby system.
//	else if(swiDis < 7 || galaxyNumber >7 || galaxyNumber <0) swiJumpRoute = [s,t]
//	else if(swiDis < 7) swiJumpRoute = [s,t]
	else if(swiDis < 7 && (system.isInterstellarSpace || missionVariables.swi_Jumper > 0)) swiJumpRoute = [s,t]	// ADDED mode check!
		else if(System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,t),"OPTIMIZED_BY_TIME") ) {	// Checks if the destination is unreachable. May not work correctly from Interstellar Space!
// Sets a jump Path route from current starting system to targeted destination system.

				if(missionVariables.swi_Jumper < 4) swiJumpRoute = System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,t), "OPTIMIZED_BY_TIME").route
				else swiJumpRoute = System.infoForSystem(galaxyNumber,s).routeToSystem(System.infoForSystem(galaxyNumber,t), "OPTIMIZED_BY_JUMPS").route;
//			} else player.commsMessage("Destination unreachable through ordinary jumps!",6);
			} else if(missionVariables.swi_Jumper == 4) swiJumpRoute = [s,299]	// 299 = Jump to a random nearby system.
			 else player.commsMessage("Destination unreachable through ordinary jumps!",6);
	} else var swiDis = 0;
	swiJumpStartTime = clock.seconds;	// Announces Jump Path chain and Starting Time. Used to calculate total travel time much later.
	player.commsMessage("Jump Path = "+swiJumpRoute+" starting from "+s+" to "+t+" for "+swiDis+" LY distance, starting at "+clock.clockString,6);
	log(this.name,"Jump Path: ",swiJumpRoute," s, Last Jump: ",s,t," start counting at: ",swiJumpCount,swiJumpRoute[swiJumpRoute.length-1],swiJumpRoute.length);
	if(swiJumpRoute[0] > -2) swiJumpCount = 1;
//	log(this.name,"PRECHECK! s, Last Jump: ",s,t," count: ",swiJumpCount,swiJumpRoute.length,"Jump Path: ",swiJumpRoute);
	this.$SwiJumpToDestination();
} else player.commsMessage("Jumping failed, equipment damaged or missing!");
}

this.playerStartedJumpCountdown = this.playerCancelledJumpCountdown = this.shipWillLaunchFromStation = this.playerEnteredNewGalaxy = function (jump)
{	// These reset the counters
	swiJumpCount = -7;
	swiJumpRoute = [-7];
}

this.shipExitedWitchspace = function()
{
//	log(this.name,"Exited Jump!",swiJumpCount,"Jump counter, swiPrevJump, system.ID - Current System, swiNextJump, jumpPath_Array ",swiPrevJump,system.ID,swiNextJump,jumpPath_Array);

	if(swiJumpCount > -1 && player.ship.equipmentStatus("EQ_WORMHOLE_SCANNER") == "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_ADVANCED_NAVIGATIONAL_ARRAY") == "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_SWI_AUTOJUMPER") == "EQUIPMENT_OK") this.$SwiJumpToDestination()	// Determines if last jump was caused by this OXP...
	else {
		swiJumpCount = -6;
		swiJumpRoute = [-8];
	}
}

this.mode = function ()
{
	if(player.ship.equipmentStatus("EQ_SWI_AUTOJUMPER") == "EQUIPMENT_OK") {
		if(missionVariables.swi_Jumper > 3 || missionVariables.swi_Jumper == null) {
			missionVariables.swi_Jumper = 0;
			player.commsMessage("Switeck AutoJumper default mode 0 -- using short-range <7 LY jump chains, shortcuts, and special routes!",6);
		} else {
			missionVariables.swi_Jumper++;
			if(missionVariables.swi_Jumper == 1) player.commsMessage("Switeck AutoJumper mode 1 -- auto-find short <7 LY jump routes disabled.",6);
			if(missionVariables.swi_Jumper == 2) player.commsMessage("Switeck AutoJumper mode 2 -- auto-find shortcuts AND short <7 LY multi-jump routes disabled.",6);
			if(missionVariables.swi_Jumper == 3) player.commsMessage("Switeck AutoJumper mode 3 -- no special/fixed pre-programmed routes used.",6);
			if(missionVariables.swi_Jumper == 4) player.commsMessage("Switeck AutoJumper mode 4 -- use fewest jumps instead of quickest time.",6);
		}
	} else player.commsMessage("Switeck AutoJumper equipment DAMAGED and unusable!",6);
}

this.$SwiJumpToDestination = function()
{
	if(swiJumpCount > -1 && swiJumpCount <swiJumpRoute.length && system.ID != parseInt(swiJumpRoute[swiJumpRoute.length-1])) {	// Checks if there's more jumps to be done.
//		if(system.isInterstellarSpace && swiJumpCount >0) swiJumpCount --;	// If in interstellar space, retry last jump!
//		if(system.ID != parseInt(swiJumpRoute[swiJumpCount-1]) && swiJumpCount >0) swiJumpCount --;	// Not where expected to be, retry last jump!
//		var swiNextJump = parseInt(swiJumpRoute[swiJumpCount]);	// Sets next system to jump to...
//		var swi_misjumpPercent = Math.floor(swiNextJump/1000);
//		var swi_destination = swiNextJump - swi_misjumpPercent*1000;
//		if(swi_destination > 699 && swi_destination < 956) swi_destination = swi_destination - 700;
//		if(swi_destination > 299 && swi_destination < 556) swi_destination = 555 - swi_destination;

//		if(system.ID == swiNextJump && swiJumpCount <swiJumpRoute.length) {	// Already at next jump location somehow...
//		if(system.ID == swiNextJump - Math.floor(swiNextJump/1000)*1000 && swiJumpCount <swiJumpRoute.length) {	// Already at next jump location somehow... also catches attempts to MISJUMP to present system!
//		if(system.ID == swi_destination && swiJumpCount <swiJumpRoute.length) {	// Already at next jump location somehow... also catches attempts to MISJUMP to present system!
//			swiJumpCount++;

//	This ELSE isn't "safe" to do if jumper tries to find misjump "shortcuts" as well!
//		} else if(swiJumpCount >0 && system.ID != parseInt(swiJumpRoute[swiJumpCount-1]) && parseInt(swiJumpRoute[swiJumpCount-1]) < 256 && parseInt(swiJumpRoute[swiJumpCount-1]) > -1) {
//		} else if(swiJumpCount >0 && system.ID != swiPrevJump && swiPrevJump < 256 && swiPrevJump > -1) {
//			swiJumpCount --;	// If last jump was to a regular system but ended up somewhere else, retry last jump! (in future do distance checks for next jump?)

		var i = 0;
//		var swiNextJump = -9;
		var swiNextJump2 = -9;
		var swiNextJump3 = -9;
//		var swi_misjumpPercent = -9;
		var swi_misjumpPercent2 = -9;
		var swi_misjumpPercent3 = -9;
//		var swi_destination = -9;
		var swi_destination2 = -9;
		var swi_destination3 = -9;
		do {
//			var swiNextJump = parseInt(swiJumpRoute[swiJumpCount]);	// Sets next system to jump to...
//			var swi_misjumpPercent = Math.floor(swiNextJump/1000);
			var swiNextJump = swiJumpRoute[swiJumpCount];	// Sets next system to jump to...
//			if( swiNextJump > parseInt(swiJumpRoute[swiJumpCount]) ) {
			if( swiNextJump > Math.floor(swiNextJump) ) {
				var swi_misjumpPercent = (swiNextJump - Math.floor(swiNextJump))*100;
//				var swi_misjumpPercent = swiNextJump - parseInt(swiJumpRoute[swiJumpCount]);
//				var swiNextJump = parseInt(swiJumpRoute[swiJumpCount]);
				var swiNextJump = Math.floor(swiNextJump);
				swi_misjumpPercent += Math.floor(swiNextJump/1000);
			} else var swi_misjumpPercent = Math.floor(swiNextJump/1000);
//			var swi_destination = swiNextJump - swi_misjumpPercent*1000;
			var swi_destination = swiNextJump - Math.floor(swiNextJump/1000)*1000;
			if(swi_destination > 699 && swi_destination <1000) swi_destination = swi_destination - 700;
			if(swi_destination > 299 && swi_destination < 600) swi_destination = 555 - swi_destination;
			if(swiJumpCount+1 <swiJumpRoute.length) {
				var swiNextJump2 = parseInt(swiJumpRoute[swiJumpCount+1]);	// Sets 2nd next system to jump to...
				var swi_misjumpPercent2 = Math.floor(swiNextJump2/1000);
				var swi_destination2 = swiNextJump2 - swi_misjumpPercent2*1000;
				if(swi_destination2 > 699 && swi_destination2 <1000) swi_destination2 = swi_destination2 - 700;
				if(swi_destination2 > 299 && swi_destination2 < 600) swi_destination2 = 555 - swi_destination2;
			}
			if(swiJumpCount+2 <swiJumpRoute.length) {
				var swiNextJump3 = parseInt(swiJumpRoute[swiJumpCount+2]);	// Sets 3rd next system to jump to...
				var swi_misjumpPercent3 = Math.floor(swiNextJump3/1000);
				var swi_destination3 = swiNextJump3 - swi_misjumpPercent3*1000;
				if(swi_destination3 > 699 && swi_destination3 <1000) swi_destination3 = swi_destination3 - 700;
				if(swi_destination3 > 299 && swi_destination3 < 600) swi_destination3 = 555 - swi_destination3;
			}
			log(this.name,"Safety checks being done... Sys.ID , Last Jump, Next Jump: "+system.ID,swiPrevJump,swiNextJump,swi_destination,swiNextJump2,swi_destination2,swiNextJump3,swi_destination3);
// ANOTHER possibility to check is if the current jump is impossible due to being >7 L.Y. ...check if the 2nd or 3rd jumps are to regular systems and if so jump to them if they're <7 L.Y. away.
			if(system.ID == swi_destination && swiJumpCount <swiJumpRoute.length) {	// Already at next jump location somehow... also catches attempts to MISJUMP to present system!
				swiJumpCount++;
				player.commsMessage("DESTINATION ALREADY REACHED - SKIPPING NEXT JUMP!",6);
				log(this.name,"DESTINATION ALREADY REACHED - SKIPPING NEXT JUMP!");
			} else if(system.ID == swi_destination2 && swi_misjumpPercent2 == 0) {	// Already at 2nd next jump location somehow...
				swiJumpCount=swiJumpCount+2;
				player.commsMessage("DESTINATION ALREADY REACHED - SKIPPING NEXT 2 JUMPS!",6);
				log(this.name,"DESTINATION ALREADY REACHED - SKIPPING NEXT 2 JUMPS!");
			} else if(system.ID == swi_destination3 && swi_misjumpPercent3 == 0) {	// Already at 3rd next jump location somehow...
				swiJumpCount=swiJumpCount+3;
				player.commsMessage("DESTINATION ALREADY REACHED - SKIPPING NEXT 3 JUMPS!",6);
				log(this.name,"DESTINATION ALREADY REACHED - SKIPPING NEXT 3 JUMPS!");
			} else if(swiJumpCount >0 && system.ID != swiPrevJump && swiPrevJump < 256 && swiPrevJump > -1) {	// If last jump was to a regular system but ended up somewhere else, retry last jump! (in future do distance checks for next jump?)
				swiJumpCount --;
				player.commsMessage("UNKNOWN FAILURE - RETRYING LAST JUMP!",6);
				log(this.name,"UNKNOWN FAILURE - RETRYING LAST JUMP!");
				swiPrevJump = system.ID; // Added to fix repeated checks!
			} else i=1;
			if(swiJumpCount >=swiJumpRoute.length) i=1;	// Done to avoid infinite looping! Probably should somehow jump to "finished jumps" routine instead...
		} while (i==0);

//		log(this.name," system.ID, swiNextJump, Last Jump: ",system.ID,swiNextJump,player.ship.targetSystem," count: ",swiJumpCount,swiJumpRoute.length,"Jump Path: ",swiJumpRoute);
//		log(this.name," system.ID, swiNextJump, swi_destination, swi_misjumpPercent, TargetSystem, Last Jump: ",system.ID,swiNextJump, swi_destination, swi_misjumpPercent, player.ship.targetSystem, swiJumpRoute[swiJumpRoute.length-1],swiPrevJump," count: ",swiJumpCount,swiJumpRoute.length);

		if(swiJumpCount >=swiJumpRoute.length) {	// All jumps are DONE?
			swiJumpCount = -7;
			swiJumpRoute = [-1];
			if(system.isInterstellarSpace) player.commsMessage("At x,y: "+Number(player.ship.galaxyCoordinates.x).toFixed(6)+" , "+Number(player.ship.galaxyCoordinates.y).toFixed(6),6)
			else player.commsMessage("At system #"+system.ID+" x,y: "+player.ship.galaxyCoordinates.x+" , "+player.ship.galaxyCoordinates.y,6);
			player.commsMessage("Jump Path abnormal exit! Computing travel time, please wait...",6);
			if(this.checkTimer) this.checkTimer.start()
			else this.checkTimer = new Timer(this, this.$Swi_calcTime, 1, 1);
			return;
		}

		if(swi_misjumpPercent >= 100) swi_misjumpPercent = 100*Math.random();	// Misjump distance is random if equal or over 100%!

// Only if swiNextJump is to a regular system does it currently try to find a quicker misjump! No check is made for single-jumps, otherwise fine-tuning and testing would be harder!
// FURTHER EXTENSION could check if swiNextJump2 is to a regular system 0-255 OR if swiNextJump2 is a misjump followed by swiNextJump3 to a regular system 0-255, where both swiNextJump2 and swiNextJump3 are to the same system (last 3 digits the same)!
// These checks would not need another for loop, they'd run the same time as the swiNextJump checks -- using the destination of swiNextJump as the start of swiNextJump2/swiNextJump3.
//		if(swiJumpCount <swiJumpRoute.length && swiJumpRoute.length >2 && swiNextJump > -1 && swiNextJump < 1000 && !system.isInterstellarSpace ) {
//		if(swiJumpCount <swiJumpRoute.length && swiJumpRoute.length >2 && swiNextJump > -1 && swiNextJump < 1000 && ((swiPrevJump >999 && swiNextJump != swiPrevJump - Math.floor(swiPrevJump/1000)*1000) ||  (swiPrevJump <1000 && swiNextJump != swiPrevJump)) ) {
//		if(swiJumpCount <swiJumpRoute.length && swiJumpRoute.length >2 && swiNextJump > -1 && swiNextJump < 256 && swiNextJump != swiPrevJump - Math.floor(swiPrevJump/1000)*1000 ) {
//		if(swiJumpCount <swiJumpRoute.length && swiNextJump < 1000) { // Only if swiNextJump is to a regular system does it currently try to find a quicker misjump!
		if(swiJumpCount <swiJumpRoute.length && missionVariables.swi_Jumper < 2 && swiNextJump > -1 && swiNextJump < 256 && swiNextJump != swiPrevJump - Math.floor(swiPrevJump/1000)*1000 ) {
// Stores player ship current location's X and Y
//			var curX = Math.floor(player.ship.galaxyCoordinates.x);
//			var curY = Math.floor(player.ship.galaxyCoordinates.y);
//			var swiDestX = Math.floor(System.infoForSystem(galaxyNumber,swi_destination).internalCoordinates.x);
//			var swiDestY = Math.floor(System.infoForSystem(galaxyNumber,swi_destination).internalCoordinates.y);
			var curX = Math.abs(player.ship.galaxyCoordinates.x);
			var curY = Math.abs(player.ship.galaxyCoordinates.y);
			var swiDestX = Math.abs(System.infoForSystem(galaxyNumber,swi_destination).internalCoordinates.x);
			var swiDestY = Math.abs(System.infoForSystem(galaxyNumber,swi_destination).internalCoordinates.y);
			var xDif = Math.floor(Math.abs(curX - swiDestX));
			var yDif = Math.floor(Math.abs(curY - swiDestY)*0.5);
			var iDis = Number((0.4*Math.floor(Math.sqrt(xDif*xDif + yDif*yDif))).toFixed(1));
//			var iDis = 0.4*Math.floor(Math.sqrt(xDif*xDif + yDif*yDif));
//			var iDis = Number(iDis.toFixed(1));
			var iTime = Number((iDis*iDis).toFixed(2));
			var swi_misjumpPercent0 = 9999;
			var i3Time = iTime;
			if(iDis <= 7 && iDis > 0) {
			log(this.name,"LY distance = ",iDis," Cur x,y:",curX,curY,"Dest x,y:",swiDestX,swiDestY," xDif,yDif:",xDif,yDif," Time: ",iTime);
			for (var i=1; i< 1000; i++) {
//			for (var i=99; i>0; i--) {
				var x1Dif = xDif*i/1000;
				if(curX - swiDestX > 0) var x1Dif=-x1Dif;	// seems easier to do this than to figure out how to make xDif pos or negative above.
				var y1Dif = yDif*i/1000;
				if(curY - swiDestY > 0) var y1Dif=-y1Dif;
				var a1LX = Math.floor(curX + x1Dif);
				var a1LY = Math.floor(curY + y1Dif);
				var i1Dis =  Number((0.4*Math.floor(Math.sqrt(x1Dif*x1Dif + y1Dif*y1Dif))).toFixed(1));
				var x2Dif = Math.floor(Math.abs(a1LX - swiDestX));
				var y2Dif = Math.floor(Math.abs(a1LY - swiDestY)*0.5);
				var i2Dis =  Number((0.4*Math.floor(Math.sqrt(x2Dif*x2Dif + y2Dif*y2Dif))).toFixed(1));
				var i2Time = Number((i2Dis*i2Dis).toFixed(2));
//				var i1Time = iTime - i2Time;	// i1Time is FAR more than i1Dis*i1Dis!
//				var i1Time = Number(((iDis*iDis)-(iDis-i1Dis)*(iDis-i1Dis)).toFixed(2));
				var i1Time = Number((((2*i/1000)-((i/1000)*(i/1000)))*iTime).toFixed(2));	// The generalised formula is that a misjump of fraction 'f' (0..1) towards the destination takes (2f - f^2) as long as the original jump would have.
//				if(i1Time < 0.1) var i1Time=0.1;	// Minimum jump time has been increased to 0.1 hours to avoid 0 hour, 0 distance jumping.
//				if(i2Time < 0.1) var i2Time=0.1;	// Minimum jump time has been increased to 0.1 hours to avoid 0 hour, 0 distance jumping.
				var i3Dis = iDis-i1Dis-i2Dis; // i3Dis should be very close to 0!
//				var i2Time = Number(((i1Dis*i1Dis)+(i2Dis*i2Dis)).toFixed(2));	// OBVIOUSLY incorrect! 	i1Time is FAR more than i1Dis*i1Dis!
//			log(this.name,parseInt(i),".LY distance = ",iDis,i1Dis,i2Dis,i3Dis," Cur x,y:",curX,curY,"Dest x,y:",swiDestX,swiDestY,a1LX,a1LY," xDif,yDif:",xDif,yDif,x1Dif,y1Dif,x2Dif,y2Dif," Time Dif: ",iTime,i1Time,i2Time,(iTime-i1Time-i2Time));
				if((i1Time + i2Time < i3Time - 0.001 && swi_misjumpPercent0 !=9999) || i1Time + i2Time < i3Time - 0.1) {	// Target time to beat is 0.1 hours less than original iTime.
//				if(i1Dis + i2Dis < iDis -0.02) {
					var i3Time = i1Time + i2Time;
					var swi_misjumpPercent0 = i/10;
					log(this.name,i," swi_misjumpPercent0 "+swi_misjumpPercent0," LY distance = "+iDis,i1Dis,i2Dis,i3Dis," Cur x,y: "+curX,curY,"Dest x,y: "+swiDestX,swiDestY,a1LX,a1LY," xDif,yDif: "+xDif,yDif,x1Dif,y1Dif,x2Dif,y2Dif," Time Dif: "+i3Time+" vs "+iTime,i1Time,i2Time,(iTime-i1Time-i2Time));
//					log(this.name,parseInt(i),".LY distance = ",iDis,i1Dis,i2Dis,i3Dis," Cur x,y:",curX,curY,"Dest x,y:",swiDestX,swiDestY," xDif,yDif:",xDif,yDif," Time Dif: ",i3Time," vs ",iTime);
				}
			}
			}
			if(swi_misjumpPercent0 < 9999) {	// This means a quicker time is found via a misjump, so use that misjump distance instead and roll back the jump count by 1.
				var swi_misjumpPercent = swi_misjumpPercent0;
				if(swiDestX < curX || swiDestY < curY ) swi_misjumpPercent = Number((swi_misjumpPercent+0.000001).toFixed(1));	// HOPEFULLY corrects minor rounding issues!
//				swiNextJump = swi_destination + Math.floor(swi_misjumpPercent*10000);
				swiJumpCount--;	// Causes havoc with logic above to retry previous jump if in interstellar space after supposedly jumping to a system!
				log(this.name," swiNextJump "+swiNextJump," swi_destination "+swi_destination," swi_misjumpPercent "+swi_misjumpPercent,swi_misjumpPercent0," Estimated time needed: "+i3Time);
			}
		}
//	THERE NEEDS TO BE AN EXACT X,Y DESTINATION ESTIMATE TO BASE THE RESULTS OF THE PERCENT MISJUMP CALCULATOR ABOVE!
		log(this.name," system.ID, swiNextJump, swi_destination, swi_misjumpPercent, TargetSystem, Last Jump: "+system.ID,swiNextJump, swi_destination, swi_misjumpPercent, player.ship.targetSystem, swiJumpRoute[swiJumpRoute.length-1],swiPrevJump," count: "+swiJumpCount,swiJumpRoute.length,"Jump Path: "+swiJumpRoute);

		player.commsMessage("At x,y: "+Number(player.ship.galaxyCoordinates.x).toFixed(6)+" , "+Number(player.ship.galaxyCoordinates.y).toFixed(6),6);
		log(this.name,"At x,y: ",player.ship.galaxyCoordinates.x,player.ship.galaxyCoordinates.y);

// wormhole-making NPC ship
//		var swi2 = system.addShips("rockhermit", 1, player.ship.position.add(player.ship.heading.multiply(5000)), 0)[0]; // was distance 150, then 270
//		swi2.dockPlayer();
// for this to work, player.ship.scriptedMisjump = 1; needs to be changed to something like swi2.ship.scriptedMisjump = 1; or swi2.scriptedMisjump = 1; -- otherwise all misjumps FAIL because the player's ship is docked not misjumping.
		var swi2 = system.addShips("alloy", 1, player.ship.position.add(player.ship.heading.multiply(200)), 0)[0]; // was distance 150, then 270
//		swi2.switchAI("missileAI.plist");
//		swi2.AIState ="EXPLODE";
//		if(player.ship.scriptedMisjump == 1) swi2.scriptedMisjump = 1;
		swi2.fuel = 7;
		if(swi_misjumpPercent > 0 && swi_misjumpPercent < 100 && swi_misjumpPercent != 50) player.ship.scriptedMisjumpRange = Number(swi_misjumpPercent*0.01 +0.000001).toFixed(4);	// *0.01 quicker and maybe more accurate than /100
		if(swi_destination >-1 && swi_destination <256) {	// Determines if next jump should be a random jump.
			if(swi_misjumpPercent == 0) {	// Determines if next jump should be a misjump. swiNextJump == swi_destination ?
				player.commsMessage(swiJumpCount+".Jumping to = "+swi_destination+"."+System.systemNameForID(swi_destination),6);
			} else {
				player.commsMessage(swiJumpCount+".Mis-jumping "+Number(swi_misjumpPercent).toFixed(2)+"% to: "+swi_destination+"."+System.systemNameForID(swi_destination),6);
				player.ship.scriptedMisjump = 1;
			}
			swi2.exitSystem(swi_destination);
		} else {
			if(missionVariables.swi_Jumper == 4) player.ship.explode();	// If set to jump nowhere AND use fewest jumps = BLOW YOUR SHIP UP! (useful for testing!)
			if(swi_misjumpPercent != 0) player.ship.scriptedMisjump = 1;
//			player.commsMessage(swiJumpCount+".Jumping to random nearby system from "+system.ID+". "+System.systemNameForID(swi_destination),6);
			player.commsMessage(swiJumpCount+".Jumping to random nearby system from "+system.ID+"."+System.systemNameForID(system.ID),6);
			swi2.exitSystem();
		}
// Eliminates errant alloys used to create wormholes.
		swi2.remove(true);	// Removes NPC "jump" ship.
		swiJumpCount++;	// Increases the Jump Counter
		swiPrevJump = swi_destination + Math.ceil(swi_misjumpPercent)*1000;
//		swiPrevJump = swiNextJump;
//	player.commsMessage("BROKEN CHECK!",6);

	} else {	// This section means all jumps are DONE!
		swiJumpCount = -5;
		swiJumpRoute = [-1];
		if(system.isInterstellarSpace) player.commsMessage("At x,y: "+Number(player.ship.galaxyCoordinates.x).toFixed(6)+" , "+Number(player.ship.galaxyCoordinates.y).toFixed(6),6)
		else player.commsMessage("At system #"+system.ID+" x,y: "+player.ship.galaxyCoordinates.x+" , "+player.ship.galaxyCoordinates.y,6);
		player.commsMessage("Reached Jump Path destination! Computing travel time, please wait...",6);
		if(this.checkTimer) this.checkTimer.start()
		else this.checkTimer = new Timer(this, this.$Swi_calcTime, 1, 1);
	}
}

this.$Swi_calcTime = function() // A timer is used to calculate total jump time, since the time is stuck "adjusting" for as much as a minute after last jump.
{
	if(!clock.isAdjusting) {
		player.commsMessage("Jumping took "+Number(((clock.seconds - swiJumpStartTime)/3600).toFixed(2))+" hours, ending at "+clock.clockString,6);
		log(this.name,"Jumping took "+(Number(((clock.seconds - swiJumpStartTime)/3600).toFixed(2)))+" hours, ending at "+clock.clockString);
		this.checkTimer.stop();
	}
}
/*
Could use:
clock.adjustedSeconds
instead of:
clock.seconds

Global Variables:
swiJumpCount			= counts how many jumps already done in swiJumpRoute
jumpDis					= Total jump distance for entire Jump-Chain.
swiJumpRoute			= List of all the systems in Jump-Chain to reach final destination. End of array used to have -7 as its last value.
swiJumpStartTime	= Exact second that Jump-Chain was started, used to calculate total time for jumps.
swi_destination		= Last Jump/destination for jumping
swiNextJump			= next Stop/next Jump to do in swiJumpRoute
swiPrevJump			= prev(ious) Stop/previously visited jump in swiJumpRoute

OXP-local variables:
this.checkTimer	= Used to delay showing how long all the jumps took until clock quits adjusting.

Local-to-their-subroutine Variables: (defined using var varname = xxx;)
aDis,a1Dis,a2Dis,a3Dis,a4Dis,a5Dis	= distances for a single jump, 1st misjump, 2nd misjump, etc
a1LX,a2LX,a3LX,a4LX,a5LX	= x coordinates for misjumps along a-line single jump route.
a1LY,a2LY,a3LY,a4LY,a5LY	= y coordinates for misjumps along a-line single jump route.

aThDis				= "theoretical" measured distances for a single jump, remotely possible it may differ from aDis but normally equal to aDis.
bDis,b1Dis,b2Dis,b3Dis,b4Dis,b5Dis	= distances for a single jump, 1st misjump, 2nd misjump, etc
b1LX,b2LX,b3LX,b4LX,b5LX	= x coordinates for misjumps along b-line single jump route.
b1LY,b2LY,b3LY,b4LY,b5LY	= y coordinates for misjumps along b-line single jump route.
cDis,c1Dis,c2Dis,c3Dis,c4Dis,c5Dis		= distances for a single jump, 1st misjump, 2nd misjump, etc
curX					= x coordinate of current location.
curY					= y coordinate of current location.
i						= 'scratchpad' counting variable, used multiple places.
iDis					= scratchpad' variable, distance estimate of a short jump segment
nextStop2		= SECOND next Stop/next Jump to do in swiJumpRoute
nSX					= x coordinate of nextStop.
nSY					= y coordinate of nextStop.
nS2X				= x coordinate of nextStop2.
nS2Y				= y coordinate of nextStop2.
pDis					= distance estimate to prevJump's location.
s						= system.ID
t						= player.ship.targetSystem
TotalTime			= 'scratchpad' variable, time estimate of a short jump segment
TotalTime2		= 'scratchpad' variable, second time estimate of a short jump segment
xDif					= 'scratchpad' variable, x coordinate differences between 2 jump points.
yDif					= 'scratchpad' variable, y coordinate differences between 2 jump points.

swi2					= an alloy "ship" that is used to create wormholes for the Jump Path
swi_misjumpPercent	= percentage of total distance for current misjump to make

*/